<?php
/**
 * This file is part of the Cloudinary PHP package.
 *
 * (c) Cloudinary
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Cloudinary\Transformation;

/**
 * Interface FocalGravityInterface
 *
 * @package Cloudinary\Transformation
 */
interface FocalGravityInterface
{
    const ADVANCED_FACE      = 'adv_face';
    const ADV_FACE           = 'adv_face';
    const ADVANCED_FACES     = 'adv_faces';
    const ADV_FACES          = 'adv_faces';
    const ADVANCED_EYES      = 'adv_eyes';
    const ADV_EYES           = 'adv_eyes';
    const BODY               = 'body';
    const FACE               = 'face';
    const FACES              = 'faces';
    const NO_FACES           = 'no_faces';
    const CUSTOM             = 'custom';
    const CUSTOM_NO_OVERRIDE = 'custom_no_override';
    const OCR_TEXT           = 'ocr_text';
    const NONE               = 'none';
}
